//=============================================================================
// DanesNoTeleports
// - removes all visible teleports in the map
//=============================================================================

class DanesNoTeleports expands Mutator config(DanesNoTeleports);

var config bool bLog;
var config Name AllowTeleport[128];
var config string AllowInMap[128];

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local int i;
	local bool bSkip;

	if ( Other.IsA('VisibleTeleporter') )
		{
		bSkip = False;

		for ( i=0; i<128; i++)
			{
			
			if (( Other.Tag == AllowTeleport[i]) && ( Level.Title == AllowInMap[i] ))
				{
				if ( bLog )
					{
					log("- Teleporter: "$AllowTeleport[i]$" in map: "$Level.Title$" is allowed to bypass DanesNoTeleportsV2.");
					}
				bSkip = True;
				}
			
			}
		if ( !bSkip )
			{
			if ( bLog )
				{
				log("- Teleporter:"@Other.Tag$" was removed from the map and replaced by a pathnode.");
				}
			ReplaceWith(Other,"DanesNoTeleportsV2.DanesPathNode");
			return false;
			}

		
		}
	return true;

	
}

defaultproperties
{

}
